/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics.drawable;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.os.Build;
import android.support.v4.graphics.BitmapCompat;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable21;
import android.support.v4.view.GravityCompat;
import android.util.Log;
import java.io.InputStream;

public final class RoundedBitmapDrawableFactory {
    private static final String TAG = "RoundedBitmapDrawableFa";

    public static RoundedBitmapDrawable create(Resources res, Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 21) {
            return new RoundedBitmapDrawable21(res, bitmap);
        }
        return new DefaultRoundedBitmapDrawable(res, bitmap);
    }

    public static RoundedBitmapDrawable create(Resources res, String filepath) {
        RoundedBitmapDrawable drawable = RoundedBitmapDrawableFactory.create(res, BitmapFactory.decodeFile((String)filepath));
        if (drawable.getBitmap() == null) {
            Log.w((String)TAG, (String)("RoundedBitmapDrawable cannot decode " + filepath));
        }
        return drawable;
    }

    public static RoundedBitmapDrawable create(Resources res, InputStream is) {
        RoundedBitmapDrawable drawable = RoundedBitmapDrawableFactory.create(res, BitmapFactory.decodeStream((InputStream)is));
        if (drawable.getBitmap() == null) {
            Log.w((String)TAG, (String)("RoundedBitmapDrawable cannot decode " + is));
        }
        return drawable;
    }

    private RoundedBitmapDrawableFactory() {
    }

    private static class DefaultRoundedBitmapDrawable
    extends RoundedBitmapDrawable {
        DefaultRoundedBitmapDrawable(Resources res, Bitmap bitmap) {
            super(res, bitmap);
        }

        @Override
        public void setMipMap(boolean mipMap) {
            if (this.mBitmap != null) {
                BitmapCompat.setHasMipMap((Bitmap)this.mBitmap, (boolean)mipMap);
                this.invalidateSelf();
            }
        }

        @Override
        public boolean hasMipMap() {
            return this.mBitmap != null && BitmapCompat.hasMipMap((Bitmap)this.mBitmap);
        }

        @Override
        void gravityCompatApply(int gravity, int bitmapWidth, int bitmapHeight, Rect bounds, Rect outRect) {
            GravityCompat.apply((int)gravity, (int)bitmapWidth, (int)bitmapHeight, (Rect)bounds, (Rect)outRect, (int)0);
        }
    }
}

