/*
 * Decompiled with CFR 0.152.
 */
package fr.pcsoft.wdjava.api;

import fr.pcsoft.wdjava.core.WDObjet;
import fr.pcsoft.wdjava.core.context.WDContexte;
import fr.pcsoft.wdjava.core.context.k;
import fr.pcsoft.wdjava.core.erreur.WDErreurManager;
import fr.pcsoft.wdjava.core.ressources.messages.a;
import fr.pcsoft.wdjava.core.types.WDEntier4;
import fr.pcsoft.wdjava.core.types.WDEntier8;
import fr.pcsoft.wdjava.core.types.WDNumerique;
import fr.pcsoft.wdjava.core.types.WDReel;
import fr.pcsoft.wdjava.core.types.c;
import fr.pcsoft.wdjava.m.f;
import java.math.BigDecimal;

public class WDAPIMath {
    private static final String[] z = new String[]{WDAPIMath.z(WDAPIMath.z("k7]\u000e\u0002\u0001\"C\u0018\u0013\u000b.Q\u001d\u001a\r")), WDAPIMath.z(WDAPIMath.z("k&I\u001f\u0003\u0006\"C\u000f\u000f\u00063]\u0004\u0013")), WDAPIMath.z(WDAPIMath.z("k&N\u000e\u0019\u0006#U")), WDAPIMath.z(WDAPIMath.z("k!]\u001f\u0002\u00075U\u0019\u001a\u0004\"")), WDAPIMath.z(WDAPIMath.z("k$S\b\u0017\u0006 Y\u0012\u0002\r8U\u0012\u0012\r3Y\u000e\u001b\u0001)Y\u0019")), WDAPIMath.z(WDAPIMath.z("k$S\b\u0017\u0006 ")), WDAPIMath.z(WDAPIMath.z("k7]\u000e\u0017\u00058N\u001d\u0015\u0001)Y\u0003\u0018\u001d+")), WDAPIMath.z(WDAPIMath.z("k5]\u001f\u001f\u0006\"")), WDAPIMath.z(WDAPIMath.z("k7]\u000e\u0017\u00058N\u001d\u0015\u0001)Y\u0003\u0018\r ]\b\u001f\u000e")), WDAPIMath.z(WDAPIMath.z("k7]\u000e\u0002\u0001\"C\u0019\u0018\u001c.Y\u000e\u0013")), WDAPIMath.z(WDAPIMath.z("k&N\u000e\u0019\u0006#U\u0003\u0005\u001d7Y\u000e\u001f\r2N")), WDAPIMath.z(WDAPIMath.z("k&N\u000e\u0019\u0006#U\u0003\u001f\u0006!Y\u000e\u001f\r2N")), WDAPIMath.z(WDAPIMath.z("k&^\u000f"))};

    public static WDReel arcCosinus(double d2) {
        double d3 = StrictMath.toDegrees(StrictMath.acos(d2));
        return new WDReel(d3);
    }

    public static WDReel arcSinus(double d2) {
        double d3 = StrictMath.toDegrees(StrictMath.asin(d2));
        return new WDReel(d3);
    }

    public static WDReel arcTang(double d2) {
        double d3 = StrictMath.toDegrees(StrictMath.atan(d2));
        return new WDReel(d3);
    }

    public static WDReel cosinus(double d2) {
        double d3 = StrictMath.cos(StrictMath.toRadians(d2));
        return new WDReel(d3);
    }

    public static WDReel sinus(double d2) {
        double d3 = StrictMath.sin(StrictMath.toRadians(d2));
        return new WDReel(d3);
    }

    public static WDReel tang(double d2) {
        double d3 = StrictMath.tan(StrictMath.toRadians(d2));
        return new WDReel(d3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WDReel coTang(double d2) {
        WDContexte wDContexte = k.a(z[5], false);
        try {
            long l2 = (long)(d2 / 90.0);
            if (d2 - 90.0 * (double)l2 == 0.0) {
                if (l2 % 2L != 0L) {
                    WDReel wDReel = new WDReel(0);
                    return wDReel;
                }
                WDErreurManager.a(a.a(z[4], new String[0]));
            }
            WDReel wDReel = new WDReel(1.0 / StrictMath.tan(d2 * Math.PI / 180.0));
            return wDReel;
        }
        finally {
            wDContexte.l();
        }
    }

    public static WDEntier4 etBinaire(int n2, int n3) {
        return new WDEntier4(n2 & n3);
    }

    public static WDEntier4 ouBinaire(int n2, int n3) {
        return new WDEntier4(n2 | n3);
    }

    public static WDEntier4 ouExclusifBinaire(int n2, int n3) {
        return new WDEntier4(n2 ^ n3);
    }

    public static WDEntier4 nonBinaire(int n2) {
        return new WDEntier4(~n2);
    }

    public static WDReel exp(double d2) {
        return new WDReel(StrictMath.exp(d2));
    }

    public static WDReel ln(double d2) {
        return new WDReel(StrictMath.log(d2));
    }

    public static WDReel log(double d2) {
        return new WDReel(StrictMath.log(d2) / StrictMath.log(10.0));
    }

    public static WDReel puissance(double d2, double d3) {
        return new WDReel(Math.pow(d2, d3));
    }

    public static WDReel racine(double d2) {
        return new WDReel(Math.sqrt(d2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WDReel racine(double d2, double d3) {
        WDContexte wDContexte = k.a(z[7], false);
        try {
            int n2 = 1;
            if (d3 == 0.0) {
                WDErreurManager.a(a.a(z[6], new String[0]));
            }
            if (d2 < 0.0 && d3 / 2.0 == (double)((short)d3 / 2)) {
                WDErreurManager.a(a.a(z[8], new String[0]));
            } else if (d2 < 0.0) {
                n2 = -1;
                d2 = -d2;
            }
            WDReel wDReel = new WDReel(Math.pow(d2, 1.0 / d3) * (double)n2);
            return wDReel;
        }
        finally {
            wDContexte.l();
        }
    }

    public static WDObjet abs(WDObjet wDObjet) {
        c c2 = wDObjet.checkType(c.class);
        if (c2 != null) {
            if (c2 instanceof WDNumerique) {
                return ((WDNumerique)c2).a(c2.getBigDecimal().abs());
            }
            if (c2.a()) {
                return new WDReel(StrictMath.abs(wDObjet.getDouble()));
            }
            return new WDEntier4(StrictMath.abs(wDObjet.getInt()));
        }
        WDErreurManager.a(a.a(z[1], "", a.d(z[12])));
        return null;
    }

    public static WDObjet partieEntiere(WDObjet wDObjet) {
        if ((wDObjet = wDObjet.getValeur()).isNumerique()) {
            long l2 = BigDecimal.valueOf(wDObjet.getDouble()).setScale(0, 3).longValue();
            return l2 >= Integer.MIN_VALUE && l2 <= Integer.MAX_VALUE ? new WDEntier4(l2) : new WDEntier8(l2);
        }
        WDErreurManager.a(a.a(z[1], "", a.d(z[9])));
        return new WDEntier4(0);
    }

    public static WDObjet partieDecimale(WDObjet wDObjet) {
        c c2 = wDObjet.checkType(c.class);
        if (c2 != null) {
            if (c2 instanceof WDNumerique) {
                return ((WDNumerique)c2).a(BigDecimal.valueOf(StrictMath.abs(wDObjet.getDouble() - (double)wDObjet.getInt())));
            }
            if (c2.a()) {
                return new WDReel(StrictMath.abs(wDObjet.getDouble() - (double)wDObjet.getInt()));
            }
            return new WDEntier4(0);
        }
        WDErreurManager.a(a.a(z[1], "", a.d(z[0])));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WDObjet arrondi(WDObjet wDObjet, int n2) {
        WDContexte wDContexte = k.a(z[2], false);
        try {
            WDObjet wDObjet2 = f.a(wDObjet, n2, 4);
            return wDObjet2;
        }
        finally {
            wDContexte.l();
        }
    }

    public static WDObjet arrondi(WDObjet wDObjet) {
        return WDAPIMath.arrondi(wDObjet, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WDObjet arrondiSuperieur(WDObjet wDObjet, int n2) {
        WDContexte wDContexte = k.a(z[10], false);
        try {
            WDObjet wDObjet2 = f.a(wDObjet, n2, 2);
            return wDObjet2;
        }
        finally {
            wDContexte.l();
        }
    }

    public static WDObjet arrondiSuperieur(WDObjet wDObjet) {
        return WDAPIMath.arrondiSuperieur(wDObjet, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WDObjet arrondiInferieur(WDObjet wDObjet, int n2) {
        WDContexte wDContexte = k.a(z[11], false);
        try {
            WDObjet wDObjet2 = f.a(wDObjet, n2, 3);
            return wDObjet2;
        }
        finally {
            wDContexte.l();
        }
    }

    public static WDObjet arrondiInferieur(WDObjet wDObjet) {
        return WDAPIMath.arrondiInferieur(wDObjet, 0);
    }

    public static WDEntier4 poidsFort(int n2) {
        return new WDEntier4(n2 >> 16);
    }

    public static WDEntier4 poidsFaible(int n2) {
        n2 <<= 16;
        return new WDEntier4(n2 >>= 16);
    }

    public static WDEntier4 construitEntier(int n2, int n3) {
        return new WDEntier4((n2 & 0xFFFF) << 16 | n3 & 0xFFFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WDObjet factorielle(int n2) {
        WDContexte wDContexte = k.a(z[3], false);
        try {
            if (n2 > 20) {
                WDReel wDReel = new WDReel(Double.POSITIVE_INFINITY);
                return wDReel;
            }
            long l2 = f.a(n2);
            WDEntier8 wDEntier8 = l2 >= Integer.MIN_VALUE && l2 <= Integer.MAX_VALUE ? new WDEntier4(l2) : new WDEntier8(l2);
            return wDEntier8;
        }
        finally {
            wDContexte.l();
        }
    }

    public static WDReel arcTang2(double d2, double d3) {
        return new WDReel(StrictMath.toDegrees(StrictMath.atan2(d2, d3)));
    }

    private static char[] z(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length < 2) {
            cArray = cArray;
            cArray[0] = (char)(cArray[0] ^ 0x56);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block9: {
            int n2;
            int n3;
            block8: {
                cArray2 = cArray;
                n3 = cArray.length;
                n2 = 0;
                if (!true) break block8;
                n3 = n3;
                if (n3 <= n2) break block9;
            }
            do {
                int n4;
                cArray2 = cArray2;
                int n5 = n2;
                char c2 = cArray2[n5];
                switch (n2 % 5) {
                    case 0: {
                        n4 = 72;
                        break;
                    }
                    case 1: {
                        n4 = 103;
                        break;
                    }
                    case 2: {
                        n4 = 28;
                        break;
                    }
                    case 3: {
                        n4 = 92;
                        break;
                    }
                    default: {
                        n4 = 86;
                    }
                }
                cArray2[n5] = (char)(c2 ^ n4);
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        return new String(cArray2).intern();
    }
}

