/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.AbsSavedState;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.GravityCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewGroupCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowInsets;
import android.view.accessibility.AccessibilityEvent;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class DrawerLayout
extends ViewGroup {
    private static final String TAG = "DrawerLayout";
    private static final int[] THEME_ATTRS = new int[]{16843828};
    public static final int STATE_IDLE = 0;
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_SETTLING = 2;
    public static final int LOCK_MODE_UNLOCKED = 0;
    public static final int LOCK_MODE_LOCKED_CLOSED = 1;
    public static final int LOCK_MODE_LOCKED_OPEN = 2;
    public static final int LOCK_MODE_UNDEFINED = 3;
    private static final int MIN_DRAWER_MARGIN = 64;
    private static final int DRAWER_ELEVATION = 10;
    private static final int DEFAULT_SCRIM_COLOR = -1728053248;
    private static final int PEEK_DELAY = 160;
    private static final int MIN_FLING_VELOCITY = 400;
    private static final boolean ALLOW_EDGE_LOCK = false;
    private static final boolean CHILDREN_DISALLOW_INTERCEPT = true;
    private static final float TOUCH_SLOP_SENSITIVITY = 1.0f;
    static final int[] LAYOUT_ATTRS = new int[]{16842931};
    static final boolean CAN_HIDE_DESCENDANTS = Build.VERSION.SDK_INT >= 19;
    private static final boolean SET_DRAWER_SHADOW_FROM_ELEVATION = Build.VERSION.SDK_INT >= 21;
    private final ChildAccessibilityDelegate mChildAccessibilityDelegate = new ChildAccessibilityDelegate();
    private float mDrawerElevation;
    private int mMinDrawerMargin;
    private int mScrimColor = -1728053248;
    private float mScrimOpacity;
    private Paint mScrimPaint = new Paint();
    private final ViewDragHelper mLeftDragger;
    private final ViewDragHelper mRightDragger;
    private final ViewDragCallback mLeftCallback;
    private final ViewDragCallback mRightCallback;
    private int mDrawerState;
    private boolean mInLayout;
    private boolean mFirstLayout = true;
    private int mLockModeLeft = 3;
    private int mLockModeRight = 3;
    private int mLockModeStart = 3;
    private int mLockModeEnd = 3;
    private boolean mDisallowInterceptRequested;
    private boolean mChildrenCanceledTouch;
    @Nullable
    private DrawerListener mListener;
    private List<DrawerListener> mListeners;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private Drawable mStatusBarBackground;
    private Drawable mShadowLeftResolved;
    private Drawable mShadowRightResolved;
    private CharSequence mTitleLeft;
    private CharSequence mTitleRight;
    private Object mLastInsets;
    private boolean mDrawStatusBarBackground;
    private Drawable mShadowStart = null;
    private Drawable mShadowEnd = null;
    private Drawable mShadowLeft = null;
    private Drawable mShadowRight = null;
    private final ArrayList<View> mNonDrawerViews;

    public DrawerLayout(Context context) {
        this(context, null);
    }

    public DrawerLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrawerLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setDescendantFocusability(262144);
        float density = this.getResources().getDisplayMetrics().density;
        this.mMinDrawerMargin = (int)(64.0f * density + 0.5f);
        float minVel = 400.0f * density;
        this.mLeftCallback = new ViewDragCallback(3);
        this.mRightCallback = new ViewDragCallback(5);
        this.mLeftDragger = ViewDragHelper.create(this, 1.0f, this.mLeftCallback);
        this.mLeftDragger.setEdgeTrackingEnabled(1);
        this.mLeftDragger.setMinVelocity(minVel);
        this.mLeftCallback.setDragger(this.mLeftDragger);
        this.mRightDragger = ViewDragHelper.create(this, 1.0f, this.mRightCallback);
        this.mRightDragger.setEdgeTrackingEnabled(2);
        this.mRightDragger.setMinVelocity(minVel);
        this.mRightCallback.setDragger(this.mRightDragger);
        this.setFocusableInTouchMode(true);
        ViewCompat.setImportantForAccessibility((View)this, (int)1);
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)new AccessibilityDelegate());
        ViewGroupCompat.setMotionEventSplittingEnabled((ViewGroup)this, (boolean)false);
        if (ViewCompat.getFitsSystemWindows((View)this)) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.setOnApplyWindowInsetsListener(new View.OnApplyWindowInsetsListener(){

                    @TargetApi(value=21)
                    public WindowInsets onApplyWindowInsets(View view, WindowInsets insets) {
                        DrawerLayout drawerLayout = (DrawerLayout)view;
                        drawerLayout.setChildInsets(insets, insets.getSystemWindowInsetTop() > 0);
                        return insets.consumeSystemWindowInsets();
                    }
                });
                this.setSystemUiVisibility(1280);
                TypedArray a = context.obtainStyledAttributes(THEME_ATTRS);
                try {
                    this.mStatusBarBackground = a.getDrawable(0);
                }
                finally {
                    a.recycle();
                }
            } else {
                this.mStatusBarBackground = null;
            }
        }
        this.mDrawerElevation = 10.0f * density;
        this.mNonDrawerViews = new ArrayList();
    }

    public void setDrawerElevation(float elevation) {
        this.mDrawerElevation = elevation;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (!this.isDrawerView(child)) continue;
            ViewCompat.setElevation((View)child, (float)this.mDrawerElevation);
        }
    }

    public float getDrawerElevation() {
        if (SET_DRAWER_SHADOW_FROM_ELEVATION) {
            return this.mDrawerElevation;
        }
        return 0.0f;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setChildInsets(Object insets, boolean draw) {
        this.mLastInsets = insets;
        this.mDrawStatusBarBackground = draw;
        this.setWillNotDraw(!draw && this.getBackground() == null);
        this.requestLayout();
    }

    public void setDrawerShadow(Drawable shadowDrawable, int gravity) {
        if (SET_DRAWER_SHADOW_FROM_ELEVATION) {
            return;
        }
        if ((gravity & 0x800003) == 0x800003) {
            this.mShadowStart = shadowDrawable;
        } else if ((gravity & 0x800005) == 0x800005) {
            this.mShadowEnd = shadowDrawable;
        } else if ((gravity & 3) == 3) {
            this.mShadowLeft = shadowDrawable;
        } else if ((gravity & 5) == 5) {
            this.mShadowRight = shadowDrawable;
        } else {
            return;
        }
        this.resolveShadowDrawables();
        this.invalidate();
    }

    public void setDrawerShadow(@DrawableRes int resId, int gravity) {
        this.setDrawerShadow(ContextCompat.getDrawable((Context)this.getContext(), (int)resId), gravity);
    }

    public void setScrimColor(@ColorInt int color) {
        this.mScrimColor = color;
        this.invalidate();
    }

    @Deprecated
    public void setDrawerListener(DrawerListener listener) {
        if (this.mListener != null) {
            this.removeDrawerListener(this.mListener);
        }
        if (listener != null) {
            this.addDrawerListener(listener);
        }
        this.mListener = listener;
    }

    public void addDrawerListener(@NonNull DrawerListener listener) {
        if (listener == null) {
            return;
        }
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<DrawerListener>();
        }
        this.mListeners.add(listener);
    }

    public void removeDrawerListener(@NonNull DrawerListener listener) {
        if (listener == null) {
            return;
        }
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.remove(listener);
    }

    public void setDrawerLockMode(int lockMode) {
        this.setDrawerLockMode(lockMode, 3);
        this.setDrawerLockMode(lockMode, 5);
    }

    public void setDrawerLockMode(int lockMode, int edgeGravity) {
        int absGravity = GravityCompat.getAbsoluteGravity((int)edgeGravity, (int)ViewCompat.getLayoutDirection((View)this));
        switch (edgeGravity) {
            case 3: {
                this.mLockModeLeft = lockMode;
                break;
            }
            case 5: {
                this.mLockModeRight = lockMode;
                break;
            }
            case 0x800003: {
                this.mLockModeStart = lockMode;
                break;
            }
            case 0x800005: {
                this.mLockModeEnd = lockMode;
            }
        }
        if (lockMode != 0) {
            ViewDragHelper helper = absGravity == 3 ? this.mLeftDragger : this.mRightDragger;
            helper.cancel();
        }
        switch (lockMode) {
            case 2: {
                View toOpen = this.findDrawerWithGravity(absGravity);
                if (toOpen == null) break;
                this.openDrawer(toOpen);
                break;
            }
            case 1: {
                View toClose = this.findDrawerWithGravity(absGravity);
                if (toClose == null) break;
                this.closeDrawer(toClose);
            }
        }
    }

    public void setDrawerLockMode(int lockMode, View drawerView) {
        if (!this.isDrawerView(drawerView)) {
            throw new IllegalArgumentException("View " + drawerView + " is not a " + "drawer with appropriate layout_gravity");
        }
        int gravity = ((LayoutParams)drawerView.getLayoutParams()).gravity;
        this.setDrawerLockMode(lockMode, gravity);
    }

    public int getDrawerLockMode(int edgeGravity) {
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        switch (edgeGravity) {
            case 3: {
                int leftLockMode;
                if (this.mLockModeLeft != 3) {
                    return this.mLockModeLeft;
                }
                int n = leftLockMode = layoutDirection == 0 ? this.mLockModeStart : this.mLockModeEnd;
                if (leftLockMode == 3) break;
                return leftLockMode;
            }
            case 5: {
                int rightLockMode;
                if (this.mLockModeRight != 3) {
                    return this.mLockModeRight;
                }
                int n = rightLockMode = layoutDirection == 0 ? this.mLockModeEnd : this.mLockModeStart;
                if (rightLockMode == 3) break;
                return rightLockMode;
            }
            case 0x800003: {
                int startLockMode;
                if (this.mLockModeStart != 3) {
                    return this.mLockModeStart;
                }
                int n = startLockMode = layoutDirection == 0 ? this.mLockModeLeft : this.mLockModeRight;
                if (startLockMode == 3) break;
                return startLockMode;
            }
            case 0x800005: {
                int endLockMode;
                if (this.mLockModeEnd != 3) {
                    return this.mLockModeEnd;
                }
                int n = endLockMode = layoutDirection == 0 ? this.mLockModeRight : this.mLockModeLeft;
                if (endLockMode == 3) break;
                return endLockMode;
            }
        }
        return 0;
    }

    public int getDrawerLockMode(View drawerView) {
        if (!this.isDrawerView(drawerView)) {
            throw new IllegalArgumentException("View " + drawerView + " is not a drawer");
        }
        int drawerGravity = ((LayoutParams)drawerView.getLayoutParams()).gravity;
        return this.getDrawerLockMode(drawerGravity);
    }

    public void setDrawerTitle(int edgeGravity, CharSequence title) {
        int absGravity = GravityCompat.getAbsoluteGravity((int)edgeGravity, (int)ViewCompat.getLayoutDirection((View)this));
        if (absGravity == 3) {
            this.mTitleLeft = title;
        } else if (absGravity == 5) {
            this.mTitleRight = title;
        }
    }

    @Nullable
    public CharSequence getDrawerTitle(int edgeGravity) {
        int absGravity = GravityCompat.getAbsoluteGravity((int)edgeGravity, (int)ViewCompat.getLayoutDirection((View)this));
        if (absGravity == 3) {
            return this.mTitleLeft;
        }
        if (absGravity == 5) {
            return this.mTitleRight;
        }
        return null;
    }

    void updateDrawerState(int forGravity, int activeState, View activeDrawer) {
        int leftState = this.mLeftDragger.getViewDragState();
        int rightState = this.mRightDragger.getViewDragState();
        int state = leftState == 1 || rightState == 1 ? 1 : (leftState == 2 || rightState == 2 ? 2 : 0);
        if (activeDrawer != null && activeState == 0) {
            LayoutParams lp = (LayoutParams)activeDrawer.getLayoutParams();
            if (lp.onScreen == 0.0f) {
                this.dispatchOnDrawerClosed(activeDrawer);
            } else if (lp.onScreen == 1.0f) {
                this.dispatchOnDrawerOpened(activeDrawer);
            }
        }
        if (state != this.mDrawerState) {
            this.mDrawerState = state;
            if (this.mListeners != null) {
                int listenerCount = this.mListeners.size();
                for (int i = listenerCount - 1; i >= 0; --i) {
                    this.mListeners.get(i).onDrawerStateChanged(state);
                }
            }
        }
    }

    void dispatchOnDrawerClosed(View drawerView) {
        LayoutParams lp = (LayoutParams)drawerView.getLayoutParams();
        if ((lp.openState & 1) == 1) {
            View rootView;
            lp.openState = 0;
            if (this.mListeners != null) {
                int listenerCount = this.mListeners.size();
                for (int i = listenerCount - 1; i >= 0; --i) {
                    this.mListeners.get(i).onDrawerClosed(drawerView);
                }
            }
            this.updateChildrenImportantForAccessibility(drawerView, false);
            if (this.hasWindowFocus() && (rootView = this.getRootView()) != null) {
                rootView.sendAccessibilityEvent(32);
            }
        }
    }

    void dispatchOnDrawerOpened(View drawerView) {
        LayoutParams lp = (LayoutParams)drawerView.getLayoutParams();
        if ((lp.openState & 1) == 0) {
            lp.openState = 1;
            if (this.mListeners != null) {
                int listenerCount = this.mListeners.size();
                for (int i = listenerCount - 1; i >= 0; --i) {
                    this.mListeners.get(i).onDrawerOpened(drawerView);
                }
            }
            this.updateChildrenImportantForAccessibility(drawerView, true);
            if (this.hasWindowFocus()) {
                this.sendAccessibilityEvent(32);
            }
        }
    }

    private void updateChildrenImportantForAccessibility(View drawerView, boolean isDrawerOpen) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!isDrawerOpen && !this.isDrawerView(child) || isDrawerOpen && child == drawerView) {
                ViewCompat.setImportantForAccessibility((View)child, (int)1);
                continue;
            }
            ViewCompat.setImportantForAccessibility((View)child, (int)4);
        }
    }

    void dispatchOnDrawerSlide(View drawerView, float slideOffset) {
        if (this.mListeners != null) {
            int listenerCount = this.mListeners.size();
            for (int i = listenerCount - 1; i >= 0; --i) {
                this.mListeners.get(i).onDrawerSlide(drawerView, slideOffset);
            }
        }
    }

    void setDrawerViewOffset(View drawerView, float slideOffset) {
        LayoutParams lp = (LayoutParams)drawerView.getLayoutParams();
        if (slideOffset == lp.onScreen) {
            return;
        }
        lp.onScreen = slideOffset;
        this.dispatchOnDrawerSlide(drawerView, slideOffset);
    }

    float getDrawerViewOffset(View drawerView) {
        return ((LayoutParams)drawerView.getLayoutParams()).onScreen;
    }

    int getDrawerViewAbsoluteGravity(View drawerView) {
        int gravity = ((LayoutParams)drawerView.getLayoutParams()).gravity;
        return GravityCompat.getAbsoluteGravity((int)gravity, (int)ViewCompat.getLayoutDirection((View)this));
    }

    boolean checkDrawerViewAbsoluteGravity(View drawerView, int checkFor) {
        int absGravity = this.getDrawerViewAbsoluteGravity(drawerView);
        return (absGravity & checkFor) == checkFor;
    }

    View findOpenDrawer() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams childLp = (LayoutParams)child.getLayoutParams();
            if ((childLp.openState & 1) != 1) continue;
            return child;
        }
        return null;
    }

    void moveDrawerToOffset(View drawerView, float slideOffset) {
        float oldOffset = this.getDrawerViewOffset(drawerView);
        int width = drawerView.getWidth();
        int oldPos = (int)((float)width * oldOffset);
        int newPos = (int)((float)width * slideOffset);
        int dx = newPos - oldPos;
        drawerView.offsetLeftAndRight(this.checkDrawerViewAbsoluteGravity(drawerView, 3) ? dx : -dx);
        this.setDrawerViewOffset(drawerView, slideOffset);
    }

    View findDrawerWithGravity(int gravity) {
        int absHorizGravity = GravityCompat.getAbsoluteGravity((int)gravity, (int)ViewCompat.getLayoutDirection((View)this)) & 7;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            int childAbsGravity = this.getDrawerViewAbsoluteGravity(child);
            if ((childAbsGravity & 7) != absHorizGravity) continue;
            return child;
        }
        return null;
    }

    static String gravityToString(int gravity) {
        if ((gravity & 3) == 3) {
            return "LEFT";
        }
        if ((gravity & 5) == 5) {
            return "RIGHT";
        }
        return Integer.toHexString(gravity);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mFirstLayout = true;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode != 0x40000000 || heightMode != 0x40000000) {
            if (this.isInEditMode()) {
                if (widthMode == Integer.MIN_VALUE) {
                    widthMode = 0x40000000;
                } else if (widthMode == 0) {
                    widthMode = 0x40000000;
                    widthSize = 300;
                }
                if (heightMode == Integer.MIN_VALUE) {
                    heightMode = 0x40000000;
                } else if (heightMode == 0) {
                    heightMode = 0x40000000;
                    heightSize = 300;
                }
            } else {
                throw new IllegalArgumentException("DrawerLayout must be measured with MeasureSpec.EXACTLY.");
            }
        }
        this.setMeasuredDimension(widthSize, heightSize);
        boolean applyInsets = this.mLastInsets != null && ViewCompat.getFitsSystemWindows((View)this);
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        boolean hasDrawerOnLeftEdge = false;
        boolean hasDrawerOnRightEdge = false;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (applyInsets) {
                int cgrav = GravityCompat.getAbsoluteGravity((int)lp.gravity, (int)layoutDirection);
                if (ViewCompat.getFitsSystemWindows((View)child)) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        WindowInsets wi = (WindowInsets)this.mLastInsets;
                        if (cgrav == 3) {
                            wi = wi.replaceSystemWindowInsets(wi.getSystemWindowInsetLeft(), wi.getSystemWindowInsetTop(), 0, wi.getSystemWindowInsetBottom());
                        } else if (cgrav == 5) {
                            wi = wi.replaceSystemWindowInsets(0, wi.getSystemWindowInsetTop(), wi.getSystemWindowInsetRight(), wi.getSystemWindowInsetBottom());
                        }
                        child.dispatchApplyWindowInsets(wi);
                    }
                } else if (Build.VERSION.SDK_INT >= 21) {
                    WindowInsets wi = (WindowInsets)this.mLastInsets;
                    if (cgrav == 3) {
                        wi = wi.replaceSystemWindowInsets(wi.getSystemWindowInsetLeft(), wi.getSystemWindowInsetTop(), 0, wi.getSystemWindowInsetBottom());
                    } else if (cgrav == 5) {
                        wi = wi.replaceSystemWindowInsets(0, wi.getSystemWindowInsetTop(), wi.getSystemWindowInsetRight(), wi.getSystemWindowInsetBottom());
                    }
                    lp.leftMargin = wi.getSystemWindowInsetLeft();
                    lp.topMargin = wi.getSystemWindowInsetTop();
                    lp.rightMargin = wi.getSystemWindowInsetRight();
                    lp.bottomMargin = wi.getSystemWindowInsetBottom();
                }
            }
            if (this.isContentView(child)) {
                int contentWidthSpec = View.MeasureSpec.makeMeasureSpec((int)(widthSize - lp.leftMargin - lp.rightMargin), (int)0x40000000);
                int contentHeightSpec = View.MeasureSpec.makeMeasureSpec((int)(heightSize - lp.topMargin - lp.bottomMargin), (int)0x40000000);
                child.measure(contentWidthSpec, contentHeightSpec);
                continue;
            }
            if (this.isDrawerView(child)) {
                int childGravity;
                boolean isLeftEdgeDrawer;
                if (SET_DRAWER_SHADOW_FROM_ELEVATION && ViewCompat.getElevation((View)child) != this.mDrawerElevation) {
                    ViewCompat.setElevation((View)child, (float)this.mDrawerElevation);
                }
                boolean bl = isLeftEdgeDrawer = (childGravity = this.getDrawerViewAbsoluteGravity(child) & 7) == 3;
                if (isLeftEdgeDrawer && hasDrawerOnLeftEdge || !isLeftEdgeDrawer && hasDrawerOnRightEdge) {
                    throw new IllegalStateException("Child drawer has absolute gravity " + DrawerLayout.gravityToString(childGravity) + " but this " + TAG + " already has a " + "drawer view along that edge");
                }
                if (isLeftEdgeDrawer) {
                    hasDrawerOnLeftEdge = true;
                } else {
                    hasDrawerOnRightEdge = true;
                }
                int drawerWidthSpec = DrawerLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.mMinDrawerMargin + lp.leftMargin + lp.rightMargin), (int)lp.width);
                int drawerHeightSpec = DrawerLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(lp.topMargin + lp.bottomMargin), (int)lp.height);
                child.measure(drawerWidthSpec, drawerHeightSpec);
                continue;
            }
            throw new IllegalStateException("Child " + child + " at index " + i + " does not have a valid layout_gravity - must be Gravity.LEFT, " + "Gravity.RIGHT or Gravity.NO_GRAVITY");
        }
    }

    private void resolveShadowDrawables() {
        if (SET_DRAWER_SHADOW_FROM_ELEVATION) {
            return;
        }
        this.mShadowLeftResolved = this.resolveLeftShadow();
        this.mShadowRightResolved = this.resolveRightShadow();
    }

    private Drawable resolveLeftShadow() {
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        if (layoutDirection == 0) {
            if (this.mShadowStart != null) {
                this.mirror(this.mShadowStart, layoutDirection);
                return this.mShadowStart;
            }
        } else if (this.mShadowEnd != null) {
            this.mirror(this.mShadowEnd, layoutDirection);
            return this.mShadowEnd;
        }
        return this.mShadowLeft;
    }

    private Drawable resolveRightShadow() {
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        if (layoutDirection == 0) {
            if (this.mShadowEnd != null) {
                this.mirror(this.mShadowEnd, layoutDirection);
                return this.mShadowEnd;
            }
        } else if (this.mShadowStart != null) {
            this.mirror(this.mShadowStart, layoutDirection);
            return this.mShadowStart;
        }
        return this.mShadowRight;
    }

    private boolean mirror(Drawable drawable, int layoutDirection) {
        if (drawable == null || !DrawableCompat.isAutoMirrored((Drawable)drawable)) {
            return false;
        }
        DrawableCompat.setLayoutDirection((Drawable)drawable, (int)layoutDirection);
        return true;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mInLayout = true;
        int width = r - l;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            int newVisibility;
            float newOffset;
            int childLeft;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (this.isContentView(child)) {
                child.layout(lp.leftMargin, lp.topMargin, lp.leftMargin + child.getMeasuredWidth(), lp.topMargin + child.getMeasuredHeight());
                continue;
            }
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            if (this.checkDrawerViewAbsoluteGravity(child, 3)) {
                childLeft = -childWidth + (int)((float)childWidth * lp.onScreen);
                newOffset = (float)(childWidth + childLeft) / (float)childWidth;
            } else {
                childLeft = width - (int)((float)childWidth * lp.onScreen);
                newOffset = (float)(width - childLeft) / (float)childWidth;
            }
            boolean changeOffset = newOffset != lp.onScreen;
            int vgrav = lp.gravity & 0x70;
            switch (vgrav) {
                default: {
                    child.layout(childLeft, lp.topMargin, childLeft + childWidth, lp.topMargin + childHeight);
                    break;
                }
                case 80: {
                    int height = b - t;
                    child.layout(childLeft, height - lp.bottomMargin - child.getMeasuredHeight(), childLeft + childWidth, height - lp.bottomMargin);
                    break;
                }
                case 16: {
                    int height = b - t;
                    int childTop = (height - childHeight) / 2;
                    if (childTop < lp.topMargin) {
                        childTop = lp.topMargin;
                    } else if (childTop + childHeight > height - lp.bottomMargin) {
                        childTop = height - lp.bottomMargin - childHeight;
                    }
                    child.layout(childLeft, childTop, childLeft + childWidth, childTop + childHeight);
                    break;
                }
            }
            if (changeOffset) {
                this.setDrawerViewOffset(child, newOffset);
            }
            int n = newVisibility = lp.onScreen > 0.0f ? 0 : 4;
            if (child.getVisibility() == newVisibility) continue;
            child.setVisibility(newVisibility);
        }
        this.mInLayout = false;
        this.mFirstLayout = false;
    }

    public void requestLayout() {
        if (!this.mInLayout) {
            super.requestLayout();
        }
    }

    public void computeScroll() {
        int childCount = this.getChildCount();
        float scrimOpacity = 0.0f;
        for (int i = 0; i < childCount; ++i) {
            float onscreen = ((LayoutParams)this.getChildAt((int)i).getLayoutParams()).onScreen;
            scrimOpacity = Math.max(scrimOpacity, onscreen);
        }
        this.mScrimOpacity = scrimOpacity;
        boolean leftDraggerSettling = this.mLeftDragger.continueSettling(true);
        boolean rightDraggerSettling = this.mRightDragger.continueSettling(true);
        if (leftDraggerSettling || rightDraggerSettling) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    private static boolean hasOpaqueBackground(View v) {
        Drawable bg = v.getBackground();
        if (bg != null) {
            return bg.getOpacity() == -1;
        }
        return false;
    }

    public void setStatusBarBackground(Drawable bg) {
        this.mStatusBarBackground = bg;
        this.invalidate();
    }

    public Drawable getStatusBarBackgroundDrawable() {
        return this.mStatusBarBackground;
    }

    public void setStatusBarBackground(int resId) {
        this.mStatusBarBackground = resId != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)resId) : null;
        this.invalidate();
    }

    public void setStatusBarBackgroundColor(@ColorInt int color) {
        this.mStatusBarBackground = new ColorDrawable(color);
        this.invalidate();
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
        this.resolveShadowDrawables();
    }

    public void onDraw(Canvas c) {
        int inset;
        super.onDraw(c);
        if (this.mDrawStatusBarBackground && this.mStatusBarBackground != null && (inset = Build.VERSION.SDK_INT >= 21 ? (this.mLastInsets != null ? ((WindowInsets)this.mLastInsets).getSystemWindowInsetTop() : 0) : 0) > 0) {
            this.mStatusBarBackground.setBounds(0, 0, this.getWidth(), inset);
            this.mStatusBarBackground.draw(c);
        }
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        int shadowWidth;
        int height = this.getHeight();
        boolean drawingContent = this.isContentView(child);
        int clipLeft = 0;
        int clipRight = this.getWidth();
        int restoreCount = canvas.save();
        if (drawingContent) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View v = this.getChildAt(i);
                if (v == child || v.getVisibility() != 0 || !DrawerLayout.hasOpaqueBackground(v) || !this.isDrawerView(v) || v.getHeight() < height) continue;
                if (this.checkDrawerViewAbsoluteGravity(v, 3)) {
                    int vright = v.getRight();
                    if (vright <= clipLeft) continue;
                    clipLeft = vright;
                    continue;
                }
                int vleft = v.getLeft();
                if (vleft >= clipRight) continue;
                clipRight = vleft;
            }
            canvas.clipRect(clipLeft, 0, clipRight, this.getHeight());
        }
        boolean result = super.drawChild(canvas, child, drawingTime);
        canvas.restoreToCount(restoreCount);
        if (this.mScrimOpacity > 0.0f && drawingContent) {
            int baseAlpha = (this.mScrimColor & 0xFF000000) >>> 24;
            int imag = (int)((float)baseAlpha * this.mScrimOpacity);
            int color = imag << 24 | this.mScrimColor & 0xFFFFFF;
            this.mScrimPaint.setColor(color);
            canvas.drawRect((float)clipLeft, 0.0f, (float)clipRight, (float)this.getHeight(), this.mScrimPaint);
        } else if (this.mShadowLeftResolved != null && this.checkDrawerViewAbsoluteGravity(child, 3)) {
            shadowWidth = this.mShadowLeftResolved.getIntrinsicWidth();
            int childRight = child.getRight();
            int drawerPeekDistance = this.mLeftDragger.getEdgeSize();
            float alpha = Math.max(0.0f, Math.min((float)childRight / (float)drawerPeekDistance, 1.0f));
            this.mShadowLeftResolved.setBounds(childRight, child.getTop(), childRight + shadowWidth, child.getBottom());
            this.mShadowLeftResolved.setAlpha((int)(255.0f * alpha));
            this.mShadowLeftResolved.draw(canvas);
        } else if (this.mShadowRightResolved != null && this.checkDrawerViewAbsoluteGravity(child, 5)) {
            shadowWidth = this.mShadowRightResolved.getIntrinsicWidth();
            int childLeft = child.getLeft();
            int showing = this.getWidth() - childLeft;
            int drawerPeekDistance = this.mRightDragger.getEdgeSize();
            float alpha = Math.max(0.0f, Math.min((float)showing / (float)drawerPeekDistance, 1.0f));
            this.mShadowRightResolved.setBounds(childLeft - shadowWidth, child.getTop(), childLeft, child.getBottom());
            this.mShadowRightResolved.setAlpha((int)(255.0f * alpha));
            this.mShadowRightResolved.draw(canvas);
        }
        return result;
    }

    boolean isContentView(View child) {
        return ((LayoutParams)child.getLayoutParams()).gravity == 0;
    }

    boolean isDrawerView(View child) {
        int gravity = ((LayoutParams)child.getLayoutParams()).gravity;
        int absGravity = GravityCompat.getAbsoluteGravity((int)gravity, (int)ViewCompat.getLayoutDirection((View)child));
        if ((absGravity & 3) != 0) {
            return true;
        }
        return (absGravity & 5) != 0;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getActionMasked();
        boolean interceptForDrag = this.mLeftDragger.shouldInterceptTouchEvent(ev) | this.mRightDragger.shouldInterceptTouchEvent(ev);
        boolean interceptForTap = false;
        switch (action) {
            case 0: {
                View child;
                float x = ev.getX();
                float y = ev.getY();
                this.mInitialMotionX = x;
                this.mInitialMotionY = y;
                if (this.mScrimOpacity > 0.0f && (child = this.mLeftDragger.findTopChildUnder((int)x, (int)y)) != null && this.isContentView(child)) {
                    interceptForTap = true;
                }
                this.mDisallowInterceptRequested = false;
                this.mChildrenCanceledTouch = false;
                break;
            }
            case 2: {
                if (!this.mLeftDragger.checkTouchSlop(3)) break;
                this.mLeftCallback.removeCallbacks();
                this.mRightCallback.removeCallbacks();
                break;
            }
            case 1: 
            case 3: {
                this.closeDrawers(true);
                this.mDisallowInterceptRequested = false;
                this.mChildrenCanceledTouch = false;
            }
        }
        return interceptForDrag || interceptForTap || this.hasPeekingDrawer() || this.mChildrenCanceledTouch;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.mLeftDragger.processTouchEvent(ev);
        this.mRightDragger.processTouchEvent(ev);
        int action = ev.getAction();
        boolean wantTouchEvents = true;
        switch (action & 0xFF) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                this.mInitialMotionX = x;
                this.mInitialMotionY = y;
                this.mDisallowInterceptRequested = false;
                this.mChildrenCanceledTouch = false;
                break;
            }
            case 1: {
                View openDrawer;
                int slop;
                float dy;
                float dx;
                float x = ev.getX();
                float y = ev.getY();
                boolean peekingOnly = true;
                View touchedView = this.mLeftDragger.findTopChildUnder((int)x, (int)y);
                if (touchedView != null && this.isContentView(touchedView) && (dx = x - this.mInitialMotionX) * dx + (dy = y - this.mInitialMotionY) * dy < (float)((slop = this.mLeftDragger.getTouchSlop()) * slop) && (openDrawer = this.findOpenDrawer()) != null) {
                    peekingOnly = this.getDrawerLockMode(openDrawer) == 2;
                }
                this.closeDrawers(peekingOnly);
                this.mDisallowInterceptRequested = false;
                break;
            }
            case 3: {
                this.closeDrawers(true);
                this.mDisallowInterceptRequested = false;
                this.mChildrenCanceledTouch = false;
            }
        }
        return wantTouchEvents;
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
        this.mDisallowInterceptRequested = disallowIntercept;
        if (disallowIntercept) {
            this.closeDrawers(true);
        }
    }

    public void closeDrawers() {
        this.closeDrawers(false);
    }

    void closeDrawers(boolean peekingOnly) {
        boolean needsInvalidate = false;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (!this.isDrawerView(child) || peekingOnly && !lp.isPeeking) continue;
            int childWidth = child.getWidth();
            needsInvalidate = this.checkDrawerViewAbsoluteGravity(child, 3) ? (needsInvalidate |= this.mLeftDragger.smoothSlideViewTo(child, -childWidth, child.getTop())) : (needsInvalidate |= this.mRightDragger.smoothSlideViewTo(child, this.getWidth(), child.getTop()));
            lp.isPeeking = false;
        }
        this.mLeftCallback.removeCallbacks();
        this.mRightCallback.removeCallbacks();
        if (needsInvalidate) {
            this.invalidate();
        }
    }

    public void openDrawer(View drawerView) {
        this.openDrawer(drawerView, true);
    }

    public void openDrawer(View drawerView, boolean animate) {
        if (!this.isDrawerView(drawerView)) {
            throw new IllegalArgumentException("View " + drawerView + " is not a sliding drawer");
        }
        LayoutParams lp = (LayoutParams)drawerView.getLayoutParams();
        if (this.mFirstLayout) {
            lp.onScreen = 1.0f;
            lp.openState = 1;
            this.updateChildrenImportantForAccessibility(drawerView, true);
        } else if (animate) {
            lp.openState |= 2;
            if (this.checkDrawerViewAbsoluteGravity(drawerView, 3)) {
                this.mLeftDragger.smoothSlideViewTo(drawerView, 0, drawerView.getTop());
            } else {
                this.mRightDragger.smoothSlideViewTo(drawerView, this.getWidth() - drawerView.getWidth(), drawerView.getTop());
            }
        } else {
            this.moveDrawerToOffset(drawerView, 1.0f);
            this.updateDrawerState(lp.gravity, 0, drawerView);
            drawerView.setVisibility(0);
        }
        this.invalidate();
    }

    public void openDrawer(int gravity) {
        this.openDrawer(gravity, true);
    }

    public void openDrawer(int gravity, boolean animate) {
        View drawerView = this.findDrawerWithGravity(gravity);
        if (drawerView == null) {
            throw new IllegalArgumentException("No drawer view found with gravity " + DrawerLayout.gravityToString(gravity));
        }
        this.openDrawer(drawerView, animate);
    }

    public void closeDrawer(View drawerView) {
        this.closeDrawer(drawerView, true);
    }

    public void closeDrawer(View drawerView, boolean animate) {
        if (!this.isDrawerView(drawerView)) {
            throw new IllegalArgumentException("View " + drawerView + " is not a sliding drawer");
        }
        LayoutParams lp = (LayoutParams)drawerView.getLayoutParams();
        if (this.mFirstLayout) {
            lp.onScreen = 0.0f;
            lp.openState = 0;
        } else if (animate) {
            lp.openState |= 4;
            if (this.checkDrawerViewAbsoluteGravity(drawerView, 3)) {
                this.mLeftDragger.smoothSlideViewTo(drawerView, -drawerView.getWidth(), drawerView.getTop());
            } else {
                this.mRightDragger.smoothSlideViewTo(drawerView, this.getWidth(), drawerView.getTop());
            }
        } else {
            this.moveDrawerToOffset(drawerView, 0.0f);
            this.updateDrawerState(lp.gravity, 0, drawerView);
            drawerView.setVisibility(4);
        }
        this.invalidate();
    }

    public void closeDrawer(int gravity) {
        this.closeDrawer(gravity, true);
    }

    public void closeDrawer(int gravity, boolean animate) {
        View drawerView = this.findDrawerWithGravity(gravity);
        if (drawerView == null) {
            throw new IllegalArgumentException("No drawer view found with gravity " + DrawerLayout.gravityToString(gravity));
        }
        this.closeDrawer(drawerView, animate);
    }

    public boolean isDrawerOpen(View drawer) {
        if (!this.isDrawerView(drawer)) {
            throw new IllegalArgumentException("View " + drawer + " is not a drawer");
        }
        LayoutParams drawerLp = (LayoutParams)drawer.getLayoutParams();
        return (drawerLp.openState & 1) == 1;
    }

    public boolean isDrawerOpen(int drawerGravity) {
        View drawerView = this.findDrawerWithGravity(drawerGravity);
        if (drawerView != null) {
            return this.isDrawerOpen(drawerView);
        }
        return false;
    }

    public boolean isDrawerVisible(View drawer) {
        if (!this.isDrawerView(drawer)) {
            throw new IllegalArgumentException("View " + drawer + " is not a drawer");
        }
        return ((LayoutParams)drawer.getLayoutParams()).onScreen > 0.0f;
    }

    public boolean isDrawerVisible(int drawerGravity) {
        View drawerView = this.findDrawerWithGravity(drawerGravity);
        if (drawerView != null) {
            return this.isDrawerVisible(drawerView);
        }
        return false;
    }

    private boolean hasPeekingDrawer() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            LayoutParams lp = (LayoutParams)this.getChildAt(i).getLayoutParams();
            if (!lp.isPeeking) continue;
            return true;
        }
        return false;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams ? new LayoutParams((LayoutParams)p) : (p instanceof ViewGroup.MarginLayoutParams ? new LayoutParams((ViewGroup.MarginLayoutParams)p) : new LayoutParams(p));
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && super.checkLayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public void addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        if (this.getDescendantFocusability() == 393216) {
            return;
        }
        int childCount = this.getChildCount();
        boolean isDrawerOpen = false;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (this.isDrawerView(child)) {
                if (!this.isDrawerOpen(child)) continue;
                isDrawerOpen = true;
                child.addFocusables(views, direction, focusableMode);
                continue;
            }
            this.mNonDrawerViews.add(child);
        }
        if (!isDrawerOpen) {
            int nonDrawerViewsCount = this.mNonDrawerViews.size();
            for (int i = 0; i < nonDrawerViewsCount; ++i) {
                View child = this.mNonDrawerViews.get(i);
                if (child.getVisibility() != 0) continue;
                child.addFocusables(views, direction, focusableMode);
            }
        }
        this.mNonDrawerViews.clear();
    }

    private boolean hasVisibleDrawer() {
        return this.findVisibleDrawer() != null;
    }

    View findVisibleDrawer() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!this.isDrawerView(child) || !this.isDrawerVisible(child)) continue;
            return child;
        }
        return null;
    }

    void cancelChildViewTouch() {
        if (!this.mChildrenCanceledTouch) {
            long now = SystemClock.uptimeMillis();
            MotionEvent cancelEvent = MotionEvent.obtain((long)now, (long)now, (int)3, (float)0.0f, (float)0.0f, (int)0);
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                this.getChildAt(i).dispatchTouchEvent(cancelEvent);
            }
            cancelEvent.recycle();
            this.mChildrenCanceledTouch = true;
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.hasVisibleDrawer()) {
            event.startTracking();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            View visibleDrawer = this.findVisibleDrawer();
            if (visibleDrawer != null && this.getDrawerLockMode(visibleDrawer) == 0) {
                this.closeDrawers();
            }
            return visibleDrawer != null;
        }
        return super.onKeyUp(keyCode, event);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        View toOpen;
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (ss.openDrawerGravity != 0 && (toOpen = this.findDrawerWithGravity(ss.openDrawerGravity)) != null) {
            this.openDrawer(toOpen);
        }
        if (ss.lockModeLeft != 3) {
            this.setDrawerLockMode(ss.lockModeLeft, 3);
        }
        if (ss.lockModeRight != 3) {
            this.setDrawerLockMode(ss.lockModeRight, 5);
        }
        if (ss.lockModeStart != 3) {
            this.setDrawerLockMode(ss.lockModeStart, 0x800003);
        }
        if (ss.lockModeEnd != 3) {
            this.setDrawerLockMode(ss.lockModeEnd, 0x800005);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            boolean isClosedAndOpening;
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            boolean isOpenedAndNotClosing = lp.openState == 1;
            boolean bl = isClosedAndOpening = lp.openState == 2;
            if (!isOpenedAndNotClosing && !isClosedAndOpening) continue;
            ss.openDrawerGravity = lp.gravity;
            break;
        }
        ss.lockModeLeft = this.mLockModeLeft;
        ss.lockModeRight = this.mLockModeRight;
        ss.lockModeStart = this.mLockModeStart;
        ss.lockModeEnd = this.mLockModeEnd;
        return ss;
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        View openDrawer = this.findOpenDrawer();
        if (openDrawer != null || this.isDrawerView(child)) {
            ViewCompat.setImportantForAccessibility((View)child, (int)4);
        } else {
            ViewCompat.setImportantForAccessibility((View)child, (int)1);
        }
        if (!CAN_HIDE_DESCENDANTS) {
            ViewCompat.setAccessibilityDelegate((View)child, (AccessibilityDelegateCompat)this.mChildAccessibilityDelegate);
        }
    }

    static boolean includeChildForAccessibility(View child) {
        return ViewCompat.getImportantForAccessibility((View)child) != 4 && ViewCompat.getImportantForAccessibility((View)child) != 2;
    }

    static final class ChildAccessibilityDelegate
    extends AccessibilityDelegateCompat {
        ChildAccessibilityDelegate() {
        }

        public void onInitializeAccessibilityNodeInfo(View child, AccessibilityNodeInfoCompat info) {
            super.onInitializeAccessibilityNodeInfo(child, info);
            if (!DrawerLayout.includeChildForAccessibility(child)) {
                info.setParent(null);
            }
        }
    }

    class AccessibilityDelegate
    extends AccessibilityDelegateCompat {
        private final Rect mTmpRect = new Rect();

        AccessibilityDelegate() {
        }

        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
            if (CAN_HIDE_DESCENDANTS) {
                super.onInitializeAccessibilityNodeInfo(host, info);
            } else {
                AccessibilityNodeInfoCompat superNode = AccessibilityNodeInfoCompat.obtain((AccessibilityNodeInfoCompat)info);
                super.onInitializeAccessibilityNodeInfo(host, superNode);
                info.setSource(host);
                ViewParent parent = ViewCompat.getParentForAccessibility((View)host);
                if (parent instanceof View) {
                    info.setParent((View)parent);
                }
                this.copyNodeInfoNoChildren(info, superNode);
                superNode.recycle();
                this.addChildrenForAccessibility(info, (ViewGroup)host);
            }
            info.setClassName((CharSequence)DrawerLayout.class.getName());
            info.setFocusable(false);
            info.setFocused(false);
            info.removeAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_FOCUS);
            info.removeAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLEAR_FOCUS);
        }

        public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
            super.onInitializeAccessibilityEvent(host, event);
            event.setClassName((CharSequence)DrawerLayout.class.getName());
        }

        public boolean dispatchPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
            if (event.getEventType() == 32) {
                int edgeGravity;
                CharSequence title;
                List eventText = event.getText();
                View visibleDrawer = DrawerLayout.this.findVisibleDrawer();
                if (visibleDrawer != null && (title = DrawerLayout.this.getDrawerTitle(edgeGravity = DrawerLayout.this.getDrawerViewAbsoluteGravity(visibleDrawer))) != null) {
                    eventText.add(title);
                }
                return true;
            }
            return super.dispatchPopulateAccessibilityEvent(host, event);
        }

        public boolean onRequestSendAccessibilityEvent(ViewGroup host, View child, AccessibilityEvent event) {
            if (CAN_HIDE_DESCENDANTS || DrawerLayout.includeChildForAccessibility(child)) {
                return super.onRequestSendAccessibilityEvent(host, child, event);
            }
            return false;
        }

        private void addChildrenForAccessibility(AccessibilityNodeInfoCompat info, ViewGroup v) {
            int childCount = v.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = v.getChildAt(i);
                if (!DrawerLayout.includeChildForAccessibility(child)) continue;
                info.addChild(child);
            }
        }

        private void copyNodeInfoNoChildren(AccessibilityNodeInfoCompat dest, AccessibilityNodeInfoCompat src) {
            Rect rect = this.mTmpRect;
            src.getBoundsInParent(rect);
            dest.setBoundsInParent(rect);
            src.getBoundsInScreen(rect);
            dest.setBoundsInScreen(rect);
            dest.setVisibleToUser(src.isVisibleToUser());
            dest.setPackageName(src.getPackageName());
            dest.setClassName(src.getClassName());
            dest.setContentDescription(src.getContentDescription());
            dest.setEnabled(src.isEnabled());
            dest.setClickable(src.isClickable());
            dest.setFocusable(src.isFocusable());
            dest.setFocused(src.isFocused());
            dest.setAccessibilityFocused(src.isAccessibilityFocused());
            dest.setSelected(src.isSelected());
            dest.setLongClickable(src.isLongClickable());
            dest.addAction(src.getActions());
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private static final int FLAG_IS_OPENED = 1;
        private static final int FLAG_IS_OPENING = 2;
        private static final int FLAG_IS_CLOSING = 4;
        public int gravity = 0;
        float onScreen;
        boolean isPeeking;
        int openState;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, LAYOUT_ATTRS);
            this.gravity = a.getInt(0, 0);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, int gravity) {
            this(width, height);
            this.gravity = gravity;
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
            this.gravity = source.gravity;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }
    }

    private class ViewDragCallback
    extends ViewDragHelper.Callback {
        private final int mAbsGravity;
        private ViewDragHelper mDragger;
        private final Runnable mPeekRunnable = new Runnable(){

            @Override
            public void run() {
                ViewDragCallback.this.peekDrawer();
            }
        };

        ViewDragCallback(int gravity) {
            this.mAbsGravity = gravity;
        }

        public void setDragger(ViewDragHelper dragger) {
            this.mDragger = dragger;
        }

        public void removeCallbacks() {
            DrawerLayout.this.removeCallbacks(this.mPeekRunnable);
        }

        @Override
        public boolean tryCaptureView(View child, int pointerId) {
            return DrawerLayout.this.isDrawerView(child) && DrawerLayout.this.checkDrawerViewAbsoluteGravity(child, this.mAbsGravity) && DrawerLayout.this.getDrawerLockMode(child) == 0;
        }

        @Override
        public void onViewDragStateChanged(int state) {
            DrawerLayout.this.updateDrawerState(this.mAbsGravity, state, this.mDragger.getCapturedView());
        }

        @Override
        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            float offset;
            int childWidth = changedView.getWidth();
            if (DrawerLayout.this.checkDrawerViewAbsoluteGravity(changedView, 3)) {
                offset = (float)(childWidth + left) / (float)childWidth;
            } else {
                int width = DrawerLayout.this.getWidth();
                offset = (float)(width - left) / (float)childWidth;
            }
            DrawerLayout.this.setDrawerViewOffset(changedView, offset);
            changedView.setVisibility(offset == 0.0f ? 4 : 0);
            DrawerLayout.this.invalidate();
        }

        @Override
        public void onViewCaptured(View capturedChild, int activePointerId) {
            LayoutParams lp = (LayoutParams)capturedChild.getLayoutParams();
            lp.isPeeking = false;
            this.closeOtherDrawer();
        }

        private void closeOtherDrawer() {
            int otherGrav = this.mAbsGravity == 3 ? 5 : 3;
            View toClose = DrawerLayout.this.findDrawerWithGravity(otherGrav);
            if (toClose != null) {
                DrawerLayout.this.closeDrawer(toClose);
            }
        }

        @Override
        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            int left;
            float offset = DrawerLayout.this.getDrawerViewOffset(releasedChild);
            int childWidth = releasedChild.getWidth();
            if (DrawerLayout.this.checkDrawerViewAbsoluteGravity(releasedChild, 3)) {
                left = xvel > 0.0f || xvel == 0.0f && offset > 0.5f ? 0 : -childWidth;
            } else {
                int width = DrawerLayout.this.getWidth();
                left = xvel < 0.0f || xvel == 0.0f && offset > 0.5f ? width - childWidth : width;
            }
            this.mDragger.settleCapturedViewAt(left, releasedChild.getTop());
            DrawerLayout.this.invalidate();
        }

        @Override
        public void onEdgeTouched(int edgeFlags, int pointerId) {
            DrawerLayout.this.postDelayed(this.mPeekRunnable, 160L);
        }

        void peekDrawer() {
            int childLeft;
            View toCapture;
            boolean leftEdge;
            int peekDistance = this.mDragger.getEdgeSize();
            boolean bl = leftEdge = this.mAbsGravity == 3;
            if (leftEdge) {
                toCapture = DrawerLayout.this.findDrawerWithGravity(3);
                childLeft = (toCapture != null ? -toCapture.getWidth() : 0) + peekDistance;
            } else {
                toCapture = DrawerLayout.this.findDrawerWithGravity(5);
                childLeft = DrawerLayout.this.getWidth() - peekDistance;
            }
            if (toCapture != null && (leftEdge && toCapture.getLeft() < childLeft || !leftEdge && toCapture.getLeft() > childLeft) && DrawerLayout.this.getDrawerLockMode(toCapture) == 0) {
                LayoutParams lp = (LayoutParams)toCapture.getLayoutParams();
                this.mDragger.smoothSlideViewTo(toCapture, childLeft, toCapture.getTop());
                lp.isPeeking = true;
                DrawerLayout.this.invalidate();
                this.closeOtherDrawer();
                DrawerLayout.this.cancelChildViewTouch();
            }
        }

        @Override
        public boolean onEdgeLock(int edgeFlags) {
            return false;
        }

        @Override
        public void onEdgeDragStarted(int edgeFlags, int pointerId) {
            View toCapture = (edgeFlags & 1) == 1 ? DrawerLayout.this.findDrawerWithGravity(3) : DrawerLayout.this.findDrawerWithGravity(5);
            if (toCapture != null && DrawerLayout.this.getDrawerLockMode(toCapture) == 0) {
                this.mDragger.captureChildView(toCapture, pointerId);
            }
        }

        @Override
        public int getViewHorizontalDragRange(View child) {
            return DrawerLayout.this.isDrawerView(child) ? child.getWidth() : 0;
        }

        @Override
        public int clampViewPositionHorizontal(View child, int left, int dx) {
            if (DrawerLayout.this.checkDrawerViewAbsoluteGravity(child, 3)) {
                return Math.max(-child.getWidth(), Math.min(left, 0));
            }
            int width = DrawerLayout.this.getWidth();
            return Math.max(width - child.getWidth(), Math.min(left, width));
        }

        @Override
        public int clampViewPositionVertical(View child, int top, int dy) {
            return child.getTop();
        }
    }

    protected static class SavedState
    extends AbsSavedState {
        int openDrawerGravity = 0;
        int lockModeLeft;
        int lockModeRight;
        int lockModeStart;
        int lockModeEnd;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel in, ClassLoader loader) {
            super(in, loader);
            this.openDrawerGravity = in.readInt();
            this.lockModeLeft = in.readInt();
            this.lockModeRight = in.readInt();
            this.lockModeStart = in.readInt();
            this.lockModeEnd = in.readInt();
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.openDrawerGravity);
            dest.writeInt(this.lockModeLeft);
            dest.writeInt(this.lockModeRight);
            dest.writeInt(this.lockModeStart);
            dest.writeInt(this.lockModeEnd);
        }
    }

    public static abstract class SimpleDrawerListener
    implements DrawerListener {
        @Override
        public void onDrawerSlide(View drawerView, float slideOffset) {
        }

        @Override
        public void onDrawerOpened(View drawerView) {
        }

        @Override
        public void onDrawerClosed(View drawerView) {
        }

        @Override
        public void onDrawerStateChanged(int newState) {
        }
    }

    public static interface DrawerListener {
        public void onDrawerSlide(View var1, float var2);

        public void onDrawerOpened(View var1);

        public void onDrawerClosed(View var1);

        public void onDrawerStateChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface EdgeGravity {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface LockMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface State {
    }
}

