/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.graphics.Rect;
import android.support.annotation.RequiresApi;
import android.support.v4.app.OneShotPreDrawListener;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RequiresApi(value=21)
class FragmentTransitionCompat21 {
    FragmentTransitionCompat21() {
    }

    public static Object cloneTransition(Object transition) {
        Transition copy = null;
        if (transition != null) {
            copy = ((Transition)transition).clone();
        }
        return copy;
    }

    public static Object wrapTransitionInSet(Object transition) {
        if (transition == null) {
            return null;
        }
        TransitionSet transitionSet = new TransitionSet();
        transitionSet.addTransition((Transition)transition);
        return transitionSet;
    }

    public static void setSharedElementTargets(Object transitionObj, View nonExistentView, ArrayList<View> sharedViews) {
        TransitionSet transition = (TransitionSet)transitionObj;
        List views = transition.getTargets();
        views.clear();
        int count = sharedViews.size();
        for (int i = 0; i < count; ++i) {
            View view = sharedViews.get(i);
            FragmentTransitionCompat21.bfsAddViewChildren(views, view);
        }
        views.add(nonExistentView);
        sharedViews.add(nonExistentView);
        FragmentTransitionCompat21.addTargets(transition, sharedViews);
    }

    private static void bfsAddViewChildren(List<View> views, View startView) {
        int startIndex = views.size();
        if (FragmentTransitionCompat21.containedBeforeIndex(views, startView, startIndex)) {
            return;
        }
        views.add(startView);
        for (int index = startIndex; index < views.size(); ++index) {
            View view = views.get(index);
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup viewGroup = (ViewGroup)view;
            int childCount = viewGroup.getChildCount();
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                View child = viewGroup.getChildAt(childIndex);
                if (FragmentTransitionCompat21.containedBeforeIndex(views, child, startIndex)) continue;
                views.add(child);
            }
        }
    }

    private static boolean containedBeforeIndex(List<View> views, View view, int maxIndex) {
        for (int i = 0; i < maxIndex; ++i) {
            if (views.get(i) != view) continue;
            return true;
        }
        return false;
    }

    public static void setEpicenter(Object transitionObj, View view) {
        if (view != null) {
            Transition transition = (Transition)transitionObj;
            final Rect epicenter = new Rect();
            FragmentTransitionCompat21.getBoundsOnScreen(view, epicenter);
            transition.setEpicenterCallback(new Transition.EpicenterCallback(){

                public Rect onGetEpicenter(Transition transition) {
                    return epicenter;
                }
            });
        }
    }

    public static void getBoundsOnScreen(View view, Rect epicenter) {
        int[] loc = new int[2];
        view.getLocationOnScreen(loc);
        epicenter.set(loc[0], loc[1], loc[0] + view.getWidth(), loc[1] + view.getHeight());
    }

    public static void addTargets(Object transitionObj, ArrayList<View> views) {
        block4: {
            List targets;
            Transition transition;
            block3: {
                transition = (Transition)transitionObj;
                if (transition == null) {
                    return;
                }
                if (!(transition instanceof TransitionSet)) break block3;
                TransitionSet set = (TransitionSet)transition;
                int numTransitions = set.getTransitionCount();
                for (int i = 0; i < numTransitions; ++i) {
                    Transition child = set.getTransitionAt(i);
                    FragmentTransitionCompat21.addTargets(child, views);
                }
                break block4;
            }
            if (FragmentTransitionCompat21.hasSimpleTarget(transition) || !FragmentTransitionCompat21.isNullOrEmpty(targets = transition.getTargets())) break block4;
            int numViews = views.size();
            for (int i = 0; i < numViews; ++i) {
                transition.addTarget(views.get(i));
            }
        }
    }

    private static boolean hasSimpleTarget(Transition transition) {
        return !FragmentTransitionCompat21.isNullOrEmpty(transition.getTargetIds()) || !FragmentTransitionCompat21.isNullOrEmpty(transition.getTargetNames()) || !FragmentTransitionCompat21.isNullOrEmpty(transition.getTargetTypes());
    }

    private static boolean isNullOrEmpty(List list) {
        return list == null || list.isEmpty();
    }

    public static Object mergeTransitionsTogether(Object transition1, Object transition2, Object transition3) {
        TransitionSet transitionSet = new TransitionSet();
        if (transition1 != null) {
            transitionSet.addTransition((Transition)transition1);
        }
        if (transition2 != null) {
            transitionSet.addTransition((Transition)transition2);
        }
        if (transition3 != null) {
            transitionSet.addTransition((Transition)transition3);
        }
        return transitionSet;
    }

    public static void scheduleHideFragmentView(Object exitTransitionObj, final View fragmentView, final ArrayList<View> exitingViews) {
        Transition exitTransition = (Transition)exitTransitionObj;
        exitTransition.addListener(new Transition.TransitionListener(){

            public void onTransitionStart(Transition transition) {
            }

            public void onTransitionEnd(Transition transition) {
                transition.removeListener((Transition.TransitionListener)this);
                fragmentView.setVisibility(8);
                int numViews = exitingViews.size();
                for (int i = 0; i < numViews; ++i) {
                    ((View)exitingViews.get(i)).setVisibility(0);
                }
            }

            public void onTransitionCancel(Transition transition) {
            }

            public void onTransitionPause(Transition transition) {
            }

            public void onTransitionResume(Transition transition) {
            }
        });
    }

    public static Object mergeTransitionsInSequence(Object exitTransitionObj, Object enterTransitionObj, Object sharedElementTransitionObj) {
        Transition staggered = null;
        Transition exitTransition = (Transition)exitTransitionObj;
        Transition enterTransition = (Transition)enterTransitionObj;
        Transition sharedElementTransition = (Transition)sharedElementTransitionObj;
        if (exitTransition != null && enterTransition != null) {
            staggered = new TransitionSet().addTransition(exitTransition).addTransition(enterTransition).setOrdering(1);
        } else if (exitTransition != null) {
            staggered = exitTransition;
        } else if (enterTransition != null) {
            staggered = enterTransition;
        }
        if (sharedElementTransition != null) {
            TransitionSet together = new TransitionSet();
            if (staggered != null) {
                together.addTransition(staggered);
            }
            together.addTransition(sharedElementTransition);
            return together;
        }
        return staggered;
    }

    public static void beginDelayedTransition(ViewGroup sceneRoot, Object transition) {
        TransitionManager.beginDelayedTransition((ViewGroup)sceneRoot, (Transition)((Transition)transition));
    }

    public static ArrayList<String> prepareSetNameOverridesReordered(ArrayList<View> sharedElementsIn) {
        ArrayList<String> names = new ArrayList<String>();
        int numSharedElements = sharedElementsIn.size();
        for (int i = 0; i < numSharedElements; ++i) {
            View view = sharedElementsIn.get(i);
            names.add(view.getTransitionName());
            view.setTransitionName(null);
        }
        return names;
    }

    public static void setNameOverridesReordered(View sceneRoot, final ArrayList<View> sharedElementsOut, final ArrayList<View> sharedElementsIn, final ArrayList<String> inNames, Map<String, String> nameOverrides) {
        final int numSharedElements = sharedElementsIn.size();
        final ArrayList<String> outNames = new ArrayList<String>();
        block0: for (int i = 0; i < numSharedElements; ++i) {
            View view = sharedElementsOut.get(i);
            String name = view.getTransitionName();
            outNames.add(name);
            if (name == null) continue;
            view.setTransitionName(null);
            String inName = nameOverrides.get(name);
            for (int j = 0; j < numSharedElements; ++j) {
                if (!inName.equals(inNames.get(j))) continue;
                sharedElementsIn.get(j).setTransitionName(name);
                continue block0;
            }
        }
        OneShotPreDrawListener.add(sceneRoot, new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < numSharedElements; ++i) {
                    ((View)sharedElementsIn.get(i)).setTransitionName((String)inNames.get(i));
                    ((View)sharedElementsOut.get(i)).setTransitionName((String)outNames.get(i));
                }
            }
        });
    }

    public static void captureTransitioningViews(ArrayList<View> transitioningViews, View view) {
        if (view.getVisibility() == 0) {
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                if (viewGroup.isTransitionGroup()) {
                    transitioningViews.add((View)viewGroup);
                } else {
                    int count = viewGroup.getChildCount();
                    for (int i = 0; i < count; ++i) {
                        View child = viewGroup.getChildAt(i);
                        FragmentTransitionCompat21.captureTransitioningViews(transitioningViews, child);
                    }
                }
            } else {
                transitioningViews.add(view);
            }
        }
    }

    public static void findNamedViews(Map<String, View> namedViews, View view) {
        if (view.getVisibility() == 0) {
            String transitionName = view.getTransitionName();
            if (transitionName != null) {
                namedViews.put(transitionName, view);
            }
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                int count = viewGroup.getChildCount();
                for (int i = 0; i < count; ++i) {
                    View child = viewGroup.getChildAt(i);
                    FragmentTransitionCompat21.findNamedViews(namedViews, child);
                }
            }
        }
    }

    public static void setNameOverridesOrdered(View sceneRoot, final ArrayList<View> sharedElementsIn, final Map<String, String> nameOverrides) {
        OneShotPreDrawListener.add(sceneRoot, new Runnable(){

            @Override
            public void run() {
                int numSharedElements = sharedElementsIn.size();
                for (int i = 0; i < numSharedElements; ++i) {
                    View view = (View)sharedElementsIn.get(i);
                    String name = view.getTransitionName();
                    if (name == null) continue;
                    String inName = FragmentTransitionCompat21.findKeyForValue(nameOverrides, name);
                    view.setTransitionName(inName);
                }
            }
        });
    }

    private static String findKeyForValue(Map<String, String> map, String value) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static void scheduleRemoveTargets(Object overallTransitionObj, final Object enterTransition, final ArrayList<View> enteringViews, final Object exitTransition, final ArrayList<View> exitingViews, final Object sharedElementTransition, final ArrayList<View> sharedElementsIn) {
        Transition overallTransition = (Transition)overallTransitionObj;
        overallTransition.addListener(new Transition.TransitionListener(){

            public void onTransitionStart(Transition transition) {
                if (enterTransition != null) {
                    FragmentTransitionCompat21.replaceTargets(enterTransition, enteringViews, null);
                }
                if (exitTransition != null) {
                    FragmentTransitionCompat21.replaceTargets(exitTransition, exitingViews, null);
                }
                if (sharedElementTransition != null) {
                    FragmentTransitionCompat21.replaceTargets(sharedElementTransition, sharedElementsIn, null);
                }
            }

            public void onTransitionEnd(Transition transition) {
            }

            public void onTransitionCancel(Transition transition) {
            }

            public void onTransitionPause(Transition transition) {
            }

            public void onTransitionResume(Transition transition) {
            }
        });
    }

    public static void swapSharedElementTargets(Object sharedElementTransitionObj, ArrayList<View> sharedElementsOut, ArrayList<View> sharedElementsIn) {
        TransitionSet sharedElementTransition = (TransitionSet)sharedElementTransitionObj;
        if (sharedElementTransition != null) {
            sharedElementTransition.getTargets().clear();
            sharedElementTransition.getTargets().addAll(sharedElementsIn);
            FragmentTransitionCompat21.replaceTargets(sharedElementTransition, sharedElementsOut, sharedElementsIn);
        }
    }

    public static void replaceTargets(Object transitionObj, ArrayList<View> oldTargets, ArrayList<View> newTargets) {
        block4: {
            int i;
            List targets;
            Transition transition;
            block3: {
                transition = (Transition)transitionObj;
                if (!(transition instanceof TransitionSet)) break block3;
                TransitionSet set = (TransitionSet)transition;
                int numTransitions = set.getTransitionCount();
                for (int i2 = 0; i2 < numTransitions; ++i2) {
                    Transition child = set.getTransitionAt(i2);
                    FragmentTransitionCompat21.replaceTargets(child, oldTargets, newTargets);
                }
                break block4;
            }
            if (FragmentTransitionCompat21.hasSimpleTarget(transition) || (targets = transition.getTargets()) == null || targets.size() != oldTargets.size() || !targets.containsAll(oldTargets)) break block4;
            int targetCount = newTargets == null ? 0 : newTargets.size();
            for (i = 0; i < targetCount; ++i) {
                transition.addTarget(newTargets.get(i));
            }
            for (i = oldTargets.size() - 1; i >= 0; --i) {
                transition.removeTarget(oldTargets.get(i));
            }
        }
    }

    public static void addTarget(Object transitionObj, View view) {
        if (transitionObj != null) {
            Transition transition = (Transition)transitionObj;
            transition.addTarget(view);
        }
    }

    public static void removeTarget(Object transitionObj, View view) {
        if (transitionObj != null) {
            Transition transition = (Transition)transitionObj;
            transition.removeTarget(view);
        }
    }

    public static void setEpicenter(Object transitionObj, final Rect epicenter) {
        if (transitionObj != null) {
            Transition transition = (Transition)transitionObj;
            transition.setEpicenterCallback(new Transition.EpicenterCallback(){

                public Rect onGetEpicenter(Transition transition) {
                    if (epicenter == null || epicenter.isEmpty()) {
                        return null;
                    }
                    return epicenter;
                }
            });
        }
    }

    public static void scheduleNameReset(ViewGroup sceneRoot, final ArrayList<View> sharedElementsIn, final Map<String, String> nameOverrides) {
        OneShotPreDrawListener.add((View)sceneRoot, new Runnable(){

            @Override
            public void run() {
                int numSharedElements = sharedElementsIn.size();
                for (int i = 0; i < numSharedElements; ++i) {
                    View view = (View)sharedElementsIn.get(i);
                    String name = view.getTransitionName();
                    String inName = (String)nameOverrides.get(name);
                    view.setTransitionName(inName);
                }
            }
        });
    }
}

