/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.provider;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.DocumentsContract;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;

@RequiresApi(value=19)
class DocumentsContractApi19 {
    private static final String TAG = "DocumentFile";
    private static final int FLAG_VIRTUAL_DOCUMENT = 512;

    DocumentsContractApi19() {
    }

    public static boolean isDocumentUri(Context context, Uri self) {
        return DocumentsContract.isDocumentUri((Context)context, (Uri)self);
    }

    public static boolean isVirtual(Context context, Uri self) {
        if (!DocumentsContractApi19.isDocumentUri(context, self)) {
            return false;
        }
        return (DocumentsContractApi19.getFlags(context, self) & 0x200L) != 0L;
    }

    public static String getName(Context context, Uri self) {
        return DocumentsContractApi19.queryForString(context, self, "_display_name", null);
    }

    private static String getRawType(Context context, Uri self) {
        return DocumentsContractApi19.queryForString(context, self, "mime_type", null);
    }

    public static String getType(Context context, Uri self) {
        String rawType = DocumentsContractApi19.getRawType(context, self);
        if ("vnd.android.document/directory".equals(rawType)) {
            return null;
        }
        return rawType;
    }

    public static long getFlags(Context context, Uri self) {
        return DocumentsContractApi19.queryForLong(context, self, "flags", 0L);
    }

    public static boolean isDirectory(Context context, Uri self) {
        return "vnd.android.document/directory".equals(DocumentsContractApi19.getRawType(context, self));
    }

    public static boolean isFile(Context context, Uri self) {
        String type = DocumentsContractApi19.getRawType(context, self);
        return !"vnd.android.document/directory".equals(type) && !TextUtils.isEmpty((CharSequence)type);
    }

    public static long lastModified(Context context, Uri self) {
        return DocumentsContractApi19.queryForLong(context, self, "last_modified", 0L);
    }

    public static long length(Context context, Uri self) {
        return DocumentsContractApi19.queryForLong(context, self, "_size", 0L);
    }

    public static boolean canRead(Context context, Uri self) {
        if (context.checkCallingOrSelfUriPermission(self, 1) != 0) {
            return false;
        }
        return !TextUtils.isEmpty((CharSequence)DocumentsContractApi19.getRawType(context, self));
    }

    public static boolean canWrite(Context context, Uri self) {
        if (context.checkCallingOrSelfUriPermission(self, 2) != 0) {
            return false;
        }
        String type = DocumentsContractApi19.getRawType(context, self);
        int flags = DocumentsContractApi19.queryForInt(context, self, "flags", 0);
        if (TextUtils.isEmpty((CharSequence)type)) {
            return false;
        }
        if ((flags & 4) != 0) {
            return true;
        }
        if ("vnd.android.document/directory".equals(type) && (flags & 8) != 0) {
            return true;
        }
        return !TextUtils.isEmpty((CharSequence)type) && (flags & 2) != 0;
    }

    public static boolean delete(Context context, Uri self) {
        try {
            return DocumentsContract.deleteDocument((ContentResolver)context.getContentResolver(), (Uri)self);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(Context context, Uri self) {
        boolean bl;
        ContentResolver resolver = context.getContentResolver();
        Cursor c = null;
        try {
            c = resolver.query(self, new String[]{"document_id"}, null, null, null);
            bl = c.getCount() > 0;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                Log.w((String)TAG, (String)("Failed query: " + e));
                bl2 = false;
            }
            catch (Throwable throwable) {
                DocumentsContractApi19.closeQuietly(c);
                throw throwable;
            }
            DocumentsContractApi19.closeQuietly((AutoCloseable)c);
            return bl2;
        }
        DocumentsContractApi19.closeQuietly((AutoCloseable)c);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String queryForString(Context context, Uri self, String column, String defaultValue) {
        String string;
        Cursor c;
        block5: {
            ContentResolver resolver = context.getContentResolver();
            c = null;
            c = resolver.query(self, new String[]{column}, null, null, null);
            if (!c.moveToFirst() || c.isNull(0)) break block5;
            String string2 = c.getString(0);
            DocumentsContractApi19.closeQuietly((AutoCloseable)c);
            return string2;
        }
        try {
            string = defaultValue;
        }
        catch (Exception e) {
            String string3;
            try {
                Log.w((String)TAG, (String)("Failed query: " + e));
                string3 = defaultValue;
            }
            catch (Throwable throwable) {
                DocumentsContractApi19.closeQuietly(c);
                throw throwable;
            }
            DocumentsContractApi19.closeQuietly((AutoCloseable)c);
            return string3;
        }
        DocumentsContractApi19.closeQuietly((AutoCloseable)c);
        return string;
    }

    private static int queryForInt(Context context, Uri self, String column, int defaultValue) {
        return (int)DocumentsContractApi19.queryForLong(context, self, column, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long queryForLong(Context context, Uri self, String column, long defaultValue) {
        long l;
        Cursor c;
        block5: {
            ContentResolver resolver = context.getContentResolver();
            c = null;
            c = resolver.query(self, new String[]{column}, null, null, null);
            if (!c.moveToFirst() || c.isNull(0)) break block5;
            long l2 = c.getLong(0);
            DocumentsContractApi19.closeQuietly((AutoCloseable)c);
            return l2;
        }
        try {
            l = defaultValue;
        }
        catch (Exception e) {
            long l3;
            try {
                Log.w((String)TAG, (String)("Failed query: " + e));
                l3 = defaultValue;
            }
            catch (Throwable throwable) {
                DocumentsContractApi19.closeQuietly(c);
                throw throwable;
            }
            DocumentsContractApi19.closeQuietly((AutoCloseable)c);
            return l3;
        }
        DocumentsContractApi19.closeQuietly((AutoCloseable)c);
        return l;
    }

    private static void closeQuietly(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

